/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin;

import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.IVWConfigTreeNode;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.utils.VWSessionInfo;
import javax.swing.ImageIcon;

public class VWConfigEventLogNode
extends VWConfigBaseNode
implements IVWConfigTreeNode {
    private static final ImageIcon nodeIcon32 = VWImageLoader.createImageIcon("eventlog_32.gif");
    private static final ImageIcon nodeIcon16 = VWImageLoader.createImageIcon("eventlog_16.gif");
    private VWLogDefinition m_logDefinition = null;
    private VWSystemConfiguration m_configuration = null;

    public VWConfigEventLogNode(VWSessionInfo sessionInfo, VWLogDefinition logDef, String service, int regionID, VWSystemConfiguration sysConfig) {
        super(logDef.getName(), 4, VWConfigActionCommand.ACMD_EVENTLOG);
        try {
            this.m_sessionInfo = sessionInfo;
            this.m_logDefinition = logDef;
            this.m_serviceName = service;
            this.m_regionID = regionID;
            this.m_serverID = -1;
            this.m_configuration = sysConfig;
            this.m_description = logDef.getDescription();
            this.setIcon32(nodeIcon32);
            this.setIcon16(nodeIcon16);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Object clone() {
        VWConfigEventLogNode lNode = (VWConfigEventLogNode)super.clone();
        lNode.m_logDefinition = (VWLogDefinition)this.m_logDefinition.clone();
        lNode.m_configuration = this.m_configuration;
        return lNode;
    }

    protected VWLogDefinition getDefinition() {
        if (this.m_logDefinition != null) {
            return (VWLogDefinition)this.m_logDefinition.clone();
        }
        return null;
    }

    protected void setDefinition(VWLogDefinition newLogDef) {
        try {
            if (this.m_configuration != null && newLogDef != null) {
                this.m_configuration.updateLogDefinition(newLogDef);
                this.m_logDefinition = newLogDef;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        this.m_logDefinition = null;
        this.m_configuration = null;
        super.releaseResources();
    }

    public void selectExportComponents() {
        try {
            VWClassFactory.setIsSelectedForExport(this.m_logDefinition, this.m_exportOpt == 2, 234L);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

